<?php

use App\Http\Controllers\ProfileController;
use App\Livewire\Frontend\IndexHome;
use App\Livewire\Frontend\Pages\About;
use App\Livewire\Frontend\Pages\Contact;
use App\Livewire\Frontend\Property\AllProperties;
use App\Livewire\Frontend\Property\PropertyType;
use App\Livewire\Frontend\Property\PropertyCategory;
use App\Livewire\Frontend\Property\PropertyLocation;
use App\Livewire\Frontend\Property\PropertySearch;
use App\Livewire\Frontend\Property\ViewProperty;
use App\Livewire\Frontend\Blogs\BlogArticles;
use App\Livewire\Frontend\Blogs\ViewBlog;
use App\Livewire\Frontend\Blogs\BlogCategory;
use App\Livewire\Frontend\Faq;
use App\Livewire\Frontend\Services;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

//frontend
Route::name('frontend.')->group(function () {
    Route::get('/', IndexHome::class)->name('index');
    Route::get('/about-us', About::class)->name('about');
    Route::get('/contact-us', Contact::class)->name('contact');
    // properties
    Route::get('/all-properties', AllProperties::class)->name('all-properties');
    Route::get('/property-type/{propertyType:slug}', PropertyType::class)->name('property-type');
    Route::get('/property-category/{propertyType:slug}/{propertyCategory:slug}', PropertyCategory::class)->name('property-category');
    Route::get('/property-location/{propertyLocation:slug}', PropertyLocation::class)->name('property-location');
    Route::get('/property-results', PropertySearch::class)->name('property-search');
    Route::get('/property/{property:slug}', ViewProperty::class)->name('view-property');
    //blogs
    Route::get('/blogs', BlogArticles::class)->name('blog-articles');
    Route::get('/blog/{blog:slug}', ViewBlog::class)->name('view-blog');
    Route::get('/blog-category/{blogCategory:slug}', BlogCategory::class)->name('blog-category');
    //faqs
    
    Route::get('/faqs', Faq::class)->name('faqs');
    Route::get('/services', Services::class)->name('services');
});



Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
