@forelse($properties as $property)
    <div class="property-item property-col-list mt-4">
        <div class="row g-0">



            <div class="col-lg-3 col-md-3">
                <div class="property-image bg-overlay-gradient-04">
                    <a href="{{route('frontend.view-property',$property)}}" wire:navigate>
                    <img class="img-fluid" src="{{asset('storage/'.$property->image)}}" alt="">
                    <div class="property-lable">
                        <span class="badge badge-md bg-primary">{{$property->propertyCategory->name}}</span>
                        <span class="badge badge-md bg-info">{{$property->propertyType->name}} </span>
                    </div>
                    {{--<span class="property-trending" title="trending"><i class="fas fa-bolt"></i></span>--}}
                    {{--<div class="property-agent">
                        <div class="property-agent-image">
                            <img class="img-fluid" src="images/avatar/01.jpg" alt="">
                        </div>
                        <div class="property-agent-info">
                            <a class="property-agent-name" href="#">Alice Williams</a>
                            <span class="d-block">Company Agent</span>
                            <ul class="property-agent-contact list-unstyled">
                                <li><a href="#"><i class="fas fa-mobile-alt"></i> </a></li>
                                <li><a href="#"><i class="fas fa-envelope"></i> </a></li>
                            </ul>
                        </div>
                    </div>--}}
                    <div class="property-agent-popup">
                        <a href="#"><i class="fas fa-camera"></i> 4</a>
                    </div>
                    </a>
                </div>
            </div>
            <div class="col-lg-9 col-md-9">
                <div class="property-details">
                    <div class="property-details-inner">
                        <div class="property-details-inner-box">
                            <div class="property-details-inner-box-left">
                                <h5 class="property-title"><a href="{{route('frontend.view-property',$property)}}">{{$property->name}} </a></h5>
                                <span class="property-address"><i class="fas fa-map-marker-alt fa-xs"></i>{{$property->propertyLocation->name}}</span>
                                <span class="property-agent-date"><i class="far fa-clock fa-md"></i>{{$property->created_at->diffForHumans()}}</span>
                            </div>
                            @if($property->price !=0)
                            <div class="property-price">Ksh. {{number_format($property->price)}} @if($property->propertyType->slug==="for-rent")<span class="d-block"> / month</span>@endif</div>
                            @else
                                <div class="property-price">Price on Request</div>

                            @endif
                        </div>
                        <ul class="property-info list-unstyled d-flex">
                            @if($property->bedrooms!=0)
                                <li class="flex-fill property-bed"><i class="fas fa-bed"></i>Bed<span>{{$property->bedrooms}}</span></li>
                            @endif
                            @if($property->bathroom!=0)
                                <li class="flex-fill property-bath"><i class="fas fa-bath"></i>Bath<span>{{$property->bathroom}}</span></li>
                            @endif
                            @if($property->garage!=0)
                                <li class="flex-fill property-m-sqft"><i class="far fa-square"></i>Parking<span>{{$property->garage}}</span></li>
                            @endif
                        </ul>
                        <p class="mb-0 mt-3">
                            {!! strip_tags(\Illuminate\Support\Str::limit($property->description,200)) !!}
                        </p>




                        </ul>
                    </div>
                    <div class="property-btn">
                        <a class="property-link" href="{{route('frontend.view-property',$property)}}">See Details</a>

                    </div>
                </div>
            </div>
        </div>
    </div>
@empty
@endforelse

<div class="row">
    <div class="col-12">
        <ul class="pagination mt-3">
            {{$properties->links()}}
            {{--<li class="page-item disabled me-auto">
                <span class="page-link b-radius-none">Prev</span>
            </li>
            <li class="page-item active" aria-current="page"><span class="page-link">1 </span> <span class="sr-only">(current)</span></li>
            <li class="page-item"><a class="page-link" href="#">2</a></li>
            <li class="page-item"><a class="page-link" href="#">3</a></li>
            <li class="page-item ms-auto">
                <a class="page-link b-radius-none" href="#">Next</a>
            </li>--}}
        </ul>
    </div>
</div>
