<!--=================================
  Featured properties-->
<section class="space-ptb">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="section-title text-center">
                    <h2>Newly listed properties</h2>
                    <p>Find your dream home from our Newly added properties</p>
                </div>
            </div>
        </div>
        <div class="row">
            @forelse($properties as $property)
            <div class="col-sm-6 col-md-4">
                <div class="property-item">
                    <div class="property-image bg-overlay-gradient-04">
                        <a href="{{route('frontend.view-property',$property)}}" wire:navigate>


                        <img class="img-fluid" src="{{asset('storage/'.$property->image)}}" alt="">
                        <div class="property-lable">
                            <span class="badge badge-md bg-primary">{{$property->propertyCategory->name}}</span>
                            <span class="badge badge-md bg-info">{{$property->propertyType->name}} </span>
                        </div>
                        {{--<span class="property-trending" title="trending"><i class="fas fa-bolt"></i></span>--}}
                        {{--<div class="property-agent">
                            <div class="property-agent-image">
                                <img class="img-fluid" src="images/avatar/01.jpg" alt="">
                            </div>
                            <div class="property-agent-info">
                                <a class="property-agent-name" href="#">Alice Williams</a>
                                <span class="d-block">Company Agent</span>
                                <ul class="property-agent-contact list-unstyled">
                                    <li><a href="#"><i class="fas fa-mobile-alt"></i> </a></li>
                                    <li><a href="#"><i class="fas fa-envelope"></i> </a></li>
                                </ul>
                            </div>
                        </div>--}}
                        <div class="property-agent-popup">
                            <a href="#"><i class="fas fa-camera"></i> 06</a>
                        </div>
                        </a>
                    </div>
                    <div class="property-details">
                        <div class="property-details-inner">
                            <h5 class="property-title"><a href="{{route('frontend.view-property',$property)}}" wire:navigate>{{$property->name}} </a></h5>
                            <span class="property-address"><i class="fas fa-map-marker-alt fa-xs"></i>{{$property->propertyLocation->name}}</span>
                            <span class="property-agent-date"><i class="far fa-clock fa-md"></i>{{$property->created_at->diffForHumans()}}</span>
                         {{--   <div class="property-price">
                            Ksh. {{number_format($property->price)}} @if($property->propertyType->slug==="for-rent")<span > / month</span>@endif
                           </div>--}}

                            @if($property->price !=0)
                                <div class="property-price">Ksh. {{number_format($property->price)}} @if($property->propertyType->slug==="for-rent")<span class="d-block"> / month</span>@endif</div>
                            @else
                                <div class="property-price">Price on Request</div>

                            @endif
                          {{--  <ul class="property-info list-unstyled d-flex">
                                @if($property->bedrooms!=0)
                                    <li class="flex-fill property-bed"><i class="fas fa-bed"></i>Bed<span>{{$property->bedrooms}}</span></li>
                                @endif
                                @if($property->bathroom!=0)
                                    <li class="flex-fill property-bath"><i class="fas fa-bath"></i>Bath<span>{{$property->bathroom}}</span></li>
                                @endif
                                @if($property->garage!=0)
                                    <li class="flex-fill property-m-sqft"><i class="far fa-square"></i>Parking<span>{{$property->garage}}</span></li>
                                @endif
                            </ul>--}}
                        </div>
                        <div class="property-btn">
                            <a class="property-link" href="{{route('frontend.view-property',$property)}}" wire:navigate>See Details</a>
                            {{--<ul class="property-listing-actions list-unstyled mb-0">
                                <li class="property-compare">
                                    <a data-bs-toggle="tooltip" data-bs-placement="top" title="Compare" href="#"><i class="fas fa-exchange-alt"></i></a>
                                </li>
                                <li class="property-favourites">
                                    <a data-bs-toggle="tooltip" data-bs-placement="top" title="Favourite" href="#"><i class="far fa-heart"></i></a>
                                </li>
                            </ul>--}}
                        </div>
                    </div>
                </div>
            </div>
            @empty
            @endforelse
            <div class="col-12 text-center">
                <a class="btn btn-link" href="{{route('frontend.all-properties')}}"><i class="fas fa-plus"></i>View All Listings</a>
            </div>
        </div>
    </div>
</section>
<!--=================================
Featured properties-->
