<div>
    {{-- A good traveler has no fixed plans and is not intent upon arriving. --}}
    @include('partials.frontend.breadcrumb')

    <!--=================================
Contact -->
    <section class="space-ptb">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="section-title">
                        <h2>Contact Us</h2>
                    </div>
                </div>
            </div>
            <div class="row align-items-center">
                <div class="col-lg-5">
                    <div class="contact-address bg-light p-4">
                        @if(!empty($settings->address))
                        <div class="d-flex mb-3">
                            <div class="contact-address-icon">
                                <i class="flaticon-map text-primary font-xlll"></i>
                            </div>
                            <div class="ms-3">
                                <h6>Address</h6>
                                <p>{!! $settings->address !!}</p>
                            </div>
                        </div>
                        @endif
                        <div class="d-flex mb-3">
                            <div class="contact-address-icon">
                                <i class="flaticon-email text-primary font-xlll"></i>
                            </div>
                            <div class="ms-3">
                                <h6>Email</h6>
                                <p><a href="mailto:{{ $settings->email }}">{{$settings->email}}</a></p>
                            </div>
                        </div>
                        <div class="d-flex mb-3">
                            <div class="contact-address-icon">
                                <i class="flaticon-call text-primary font-xlll"></i>
                            </div>
                            <div class="ms-3">
                                <h6>Phone Number</h6>
                                <p><a href="tel:{{ $settings->phone_number }}">{{$settings->phone_number}}</a> @if (!empty($settings->phone_number_backup))
                                    
                                / <a href="tel:{{ $settings->phone_number_backup }}">{{$settings->phone_number_backup}}</a>
                                    
                                @endif 
                                </p>
                            </div>
                        </div>
                        <div class="d-flex mb-3">
                            <div class="contact-address-icon">
                                <i class="flaticon-fax text-primary font-xlll"></i>
                            </div>
                            <div class="ms-3">
                                <h6>WhatsApp</h6>
                                <p><a href="https://wa.me/{{ $settings->whatsapp }}">{{ $settings->whatsapp}}</a></p>
                            </div>
                        </div>
                        <div class="social-icon-02">
                            <div class="d-flex align-items-center">
                                <h6 class="me-3">Social:</h6>
                                <ul class="list-unstyled mb-0 list-inline">
                                    @if(!empty($settings->facebook))
                                        <li><a href="{{$settings->facebook}}"> <i class="fab fa-facebook-f"></i> </a></li>
                                    @endif
                                    @if(!empty($settings->twitter))
                                            <li><a href="{{$settings->twitter}}"> <i class="fab fa-twitter"></i> </a></li>
                                        @endif
                                    @if(!empty($settings->linkedin))
                                                <li><a href="{{$settings->linkedin}}"> <i class="fab fa-linkedin"></i> </a></li>
                                        @endif
                                    @if(!empty($settings->tiktok))
                                                    <li><a href="{{$settings->tiktok}}"> <i class="fab fa-tiktok"></i> </a></li>
                                        @endif
                                    @if(!empty($settings->instagram))
                                                        <li><a href="{{$settings->instagram}}"> <i class="fab fa-instagram"></i> </a></li>
                                        @endif
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-7 mt-4 mt-lg-0">
                    <div class="contact-form">
                        <h4 class="mb-4">Need assistance? Please complete the contact form</h4>
                        <form wire:submit="enquiry">
                            <div class="row">
                                <div class="mb-3 col-md-6">
                                    <input type="text" wire:model="name" class="form-control"  placeholder="Your name">

                                @error('name') <span style="color:red" class="error">{{ $message }}</span> @enderror
                                </div>
                                <div class="mb-3 col-md-6">
                                    <input type="email" wire:model="email" class="form-control"  placeholder="Your email">

                                @error('email') <span style="color:red" class="error">{{ $message }}</span> @enderror
                                </div>
                                <div class="mb-3 col-md-6">
                                    <input type="text" wire:model="phone_number" class="form-control"  placeholder="Your phone">

                                @error('phone_number') <span style="color:red" class="error">{{ $message }}</span> @enderror
                                </div>
                                <div class="mb-3 col-md-6">
                                    <input type="text" wire:model="subject" class="form-control"  placeholder="Subject">

                                @error('subject') <span style="color:red" class="error">{{ $message }}</span> @enderror
                                </div>
                                <div class="mb-3 col-md-12">
                                    <textarea wire:model="message" class="form-control" rows="4" placeholder="Your message"></textarea>

                                 @error('message') <span style="color:red" class="error">{{ $message }}</span> @enderror
                                </div>
                                {{--<div class="mb-3 col-md-12">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                        <label class="form-check-label pe-5" for="flexCheckDefault">
                                            I consent to having this website store my submitted information so they can respond to my inquiry.
                                        </label>
                                    </div>
                                </div>--}}
                                <div class="col-md-12">
                                    <button class="btn btn-primary" type="submit">Send message</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
           {{-- <div class="row mt-1 mt-md-2">
                <div class="col-12">
                    <h4 class="mb-4 my-4 my-sm-5">Additional contact Info</h4>
                </div>
                <div class="col-md-4">
                    <div class="d-flex">
                        <i class="flaticon-time-call font-xlll text-primary"></i>
                        <div class="ms-4">
                            <h5>Estate agency offices</h5>
                            <p>Our Estate Agency offices can help with you buying or selling a home.</p>
                            <a href="#">Click to contact an estate agency branch</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mt-4 mt-md-0">
                    <div class="d-flex">
                        <i class="flaticon-email-1 font-xlll text-primary"></i>
                        <div class="ms-4">
                            <h5>Lettings offices</h5>
                            <p>Our Lettings offices can assist with you letting your home, protection and moving home.</p>
                            <a href="#">Click to contact a lettings branch</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mt-4 mt-md-0">
                    <div class="d-flex">
                        <i class="flaticon-group font-xlll text-primary"></i>
                        <div class="ms-4">
                            <h5>Chat to us online</h5>
                            <p class="mb-0">Chat to us online if you have a question about using our Mortgage calculator.</p>
                            <a class="btn btn-primary btn-sm mt-3" href="#"> Start web chat</a>
                        </div>
                    </div>
                </div>
            </div>--}}
        </div>
    </section>
    <!--=================================
    Contact -->
</div>
