@forelse($blogs as $blog)
<div class="blog-post mb-5">
    <div class="blog-post-image">
        <a href="{{route('frontend.view-blog',$blog)}}" wire:navigate>
        <img class="img-fluid" src="{{asset('storage/'.$blog->image)}}" alt="{{$blog->name}}">
        </a>
    </div>
    <div class="blog-post-content">
        <div class="blog-post-details">
            <div class="blog-post-category mb-1">
                <a class="mb-3" href="{{route('frontend.blog-category',$blog->blogCategory)}}" wire:navigate><strong>{{$blog->blogCategory->name}} </strong></a>
            </div>
            <div class="blog-post-title">
                <h5><a href="{{route('frontend.view-blog',$blog)}}" wire:navigate>{{$blog->name}}</a></h5>
            </div>
            <div class="blog-post-description">
                <p class="mb-0">
                    {!! strip_tags(\Illuminate\Support\Str::limit($blog->description,200)) !!}</p>
            </div>
            <div class="blog-post-link mt-4">
                <a class="btn btn-link p-0" href="{{route('frontend.view-blog',$blog)}}" wire:navigate> Continue read</a>
            </div>
        </div>
        <div class="blog-post-footer">
            <div class="blog-post-time">
                <a href="#"> <i class="far fa-clock"></i>{{date("l jS F, Y",strtotime($blog->created_at))}}</a>
            </div>
            <div class="blog-post-author">
                <span> By <a href="#"> {{$blog->user->name}}</a> </span>
            </div>
            <div class="blog-post-comment">
                <a href="#"> <i class="far fa-eye"></i>({{number_format($blog->views)}}) </a>
            </div>
            {{--<div class="share-box">
                <a href="#"> <i class="fas fa-share-alt"></i> </a>
                <ul class="list-unstyled share-box-social">
                    <li> <a href="#"><i class="fab fa-facebook-f"></i></a> </li>
                    <li> <a href="#"><i class="fab fa-twitter"></i></a> </li>
                    <li> <a href="#"><i class="fab fa-linkedin"></i></a> </li>
                    <li> <a href="#"><i class="fab fa-instagram"></i></a> </li>
                    <li> <a href="#"><i class="fab fa-pinterest"></i></a> </li>
                </ul>
            </div>--}}
        </div>
    </div>
</div>
@empty @endforelse


<div class="row">
    <div class="col-12">
        {{$blogs->links()}}

    </div>
</div>
