<!--
 * Created by PhpStorm.
 * Framework - Laravel PHP Framework
 * Website by : Sparkworld Enterprises.
 * Website : https://sparkworld.co.ke
 * Phone Number : +254718020630
 * Emails : sparkworldke@gmail.com / hi@sparkworld.co.ke
 *-->
<!DOCTYPE html>
<!--[if IE 8 ]>
<html class="ie" xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US" lang="en-US"> <![endif]-->
<!--[if (gte IE 9)|!(IE)]><!-->
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US" lang="en-US"><!--<![endif]-->

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Primary Meta Tags -->
    <title>{{$title}} | {{ $settings->name }}</title>
    <meta name="title" content="{{ $title }}">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="canonical" href="{{ url()->current() }}">
    <meta name="robots" content="INDEX, FOLLOW" />
    <meta name="referrer" content="origin-when-cross-origin">
    <meta content="True" name="HandheldFriendly">
    <!-- Search Engine -->
    <meta name="description" content="{{ $meta_description }}">
    <meta name="keywords" content="{{ $title }}, {{ $keywords }}">

    <link rel="icon" href="{{ $settings->favicon }}">

    <meta name="image" content="{{ asset('storage/'.$image) }}">
    <!-- Schema.org for Google -->
    <meta itemprop="name" content="{{ $title }}">
    <meta itemprop="description" content="{{ $meta_description }}">
    <meta name="keywords" content="{{ $title }}, {{ $keywords }}">

    <meta itemprop="image" content="{{ asset('storage/'.$image) }}">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{ $title }}">
    <meta name="twitter:description" content=" {{ $meta_description }}">
    <meta name="twitter:site" content="{{ '@' . $settings->twitter }} ">
    <meta name="twitter:creator" content="{{ '@' . $settings->twitter }} ">
    <meta name="twitter:image:src" content="{{ asset('storage/'.$image) }}">

    <!-- Open Graph general (Facebook, Pinterest & Google+) -->
    <meta name="og:title" content="{{ $title }}">
    <meta name="og:description" content="{{ $meta_description }}">
    <meta name="og:image" content="{{ asset('storage/'.$image) }}">
    <meta name="og:url" content="{{ url()->current() }}">
    <meta name="og:site_name" content="{{ $settings->name }}">
    <meta name="og:type" content="website">
    <!--Developers Information & SEO Files if they are not null -->

    <!-- Global site tag (gtag.js) - Google Analytics -->
    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Barlow+Semi+Condensed:300,500,600,700%7CRoboto:300,400,500,700">

    @if (!empty($settings->header_scripts))
        {!! $settings->header_scripts !!}
    @endif

    @include('partials.frontend.header')

    {{-- page Css --}}
    @stack('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    @livewireStyles
</head>

<body class="gray">

    <!-- Wrapper -->
    <div id="wrapper">

        @if (!empty($settings->body_scripts))
            {!! $settings->body_scripts !!}
        @endif
        <!--Header + Nav -->
       @include('partials.frontend.navigation')
        <!--Header + Nav -->



        <!--Contents -->
        @yield('content')
        <!-- Footer -->
        @include('partials.frontend.footer')

    </div>

    <!-- Js Scripts -->
    @include('partials.frontend.scripts')


    @if (!empty($settings->footer_scripts))
        {!! $settings->footer_scripts !!}
    @endif
    {{-- page scripts --}}
    @stack('js')

    {{-- {!! NoCaptcha::renderJs() !!} --}}
   {{-- <script src="{{ asset('js/share.js') }}"></script>--}}
    @livewireScripts
</body>

</html>
