<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('property_category_property_type', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(\App\Models\PropertyCategory::class)->nullable()->constrained()->cascadeOnUpdate()->cascadeOnDelete();

            $table->foreignIdFor(\App\Models\PropertyType::class)->nullable()->constrained()->cascadeOnUpdate()->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('property_category_property_type');
    }
};
