<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('properties', function (Blueprint $table) {
            $table->id();
            $table->string('name', 191);
            $table->string('slug', 191)->unique();
            $table->longText('description')->nullable();
            $table->integer('price')->nullable();
            $table->integer('offer_price')->nullable();
            $table->dateTime('offer_end_dates')->nullable();
            $table->text('image')->nullable();
            $table->longText('gallery')->nullable();
            $table->longText('video')->nullable();
            $table->integer('bathroom')->nullable(); //
            $table->integer('bedrooms')->nullable();
            $table->integer('garage')->nullable();
            $table->foreignIdFor(\App\Models\PropertyType::class)->nullable()->constrained()->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreignIdFor(\App\Models\PropertyCategory::class)->nullable()->constrained()->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreignIdFor(\App\Models\PropertyLocation::class)->nullable()->constrained()->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreignIdFor(\App\Models\User::class)->nullable()->constrained()->cascadeOnUpdate()->cascadeOnDelete();
              $table->text('meta_description')->nullable();
            $table->text('keywords')->nullable();
            $table->boolean('status')->default(true); //1 - live 2- sold or Rented 0 - Draft
            $table->integer('featured')->default(0); //1 - live 2- sold or Rented 0 - Draft
            $table->integer('views')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('properties');
    }
};
