<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Filament\Models\Contracts\FilamentUser;
use Filament\Panel;

class User extends Authenticatable  implements FilamentUser
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes;
    protected $dates = [ 'deleted_at' ];

   protected $emailList = [
        'gmail.com',
        'test.com'
    ];
    
    public function getEmailDomain($email){
        $array = explode('@', $email);
        return $array[1];
    }

    public function canAccessPanel(Panel $panel): bool
    {
        return in_array($this->getEmailDomain($this->email),$this->emailList);
        //return str_ends_with($this->email, ['@gmail.com','@nkanyarealtors.com']);
      //  return str_ends_with($this->email, ['@gmail.com','@nkanyarealtors.com']) && $this->hasVerifiedEmail();
    }
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];
}
