<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PropertyCategory extends Model
{
    use HasFactory, SoftDeletes;
    protected $dates = [ 'deleted_at' ];
    protected $guarded = [];
    public function propertyTypes()
    {
        return $this->belongsToMany(PropertyType::class)->withTimestamps();;
    }
    public function propertyAmenities()
    {
        return $this->belongsToMany(PropertyAmenity::class)->withTimestamps();
    }
    public function property(){
        return $this->HasMany(Property::class);
    }
}
