<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PropertyAmenity extends Model
{
    use HasFactory, SoftDeletes;
    protected $dates = [ 'deleted_at' ];
    protected $guarded = [];
    //belong to category
    public function propertyCategory()
    {
        return $this->belongsToMany(PropertyCategory::class)->withTimestamps();
    }
    //belong to a property
    public function properties()
    {
        return $this->belongsToMany(Property::class)->withTimestamps();
    }
}
