<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Property extends Model
{
    use HasFactory, SoftDeletes;
    protected $dates = [ 'deleted_at' ];
    protected $guarded = [];

    public function propertyType(){
        return $this->BelongsTo(PropertyType::class);
    }
    public function propertyCategory(){
        return $this->BelongsTo(PropertyCategory::class);
    }
    public function propertyLocation(){
        return $this->BelongsTo(PropertyLocation::class);
    }

    //amenities
    public function propertyAmenities()
    {
        return $this->belongsToMany(PropertyAmenity::class)->withTimestamps();
    }
    //booking
    public function propertyBooking(){
        return $this->HasMany(PropertyBooking::class);
    }
    public function user(){
        return $this->BelongsTo(User::class);
    }
    public function slide(){
        return $this->HasMany(Slide::class);
    }


    //images
    protected $casts = [
      'gallery'=>'array'
    ];

}
