<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Blog extends Model
{
    use HasFactory, SoftDeletes;
    protected $dates = [ 'deleted_at' ];
    protected $guarded = [];
    public function blogCategory(){
        return $this->BelongsTo(BlogCategory::class);
    }
    public function user(){
        return $this->BelongsTo(User::class);
    }
}
