<?php

namespace App\Livewire\Frontend;

use Livewire\Component;
use App\Models\Services as ServiceModel;

use App\Models\PropertyCategory;
use App\Models\PropertyLocation;
use App\Models\PropertyType;
use App\Models\Setting;

class Services extends Component
{

    public function render()
    {

        $services = ServiceModel::where('status',1)->get();


        $propertyTypes = PropertyType::withoutTrashed()
            ->where('status',1)
            ->get();
        $propertyCategories = PropertyCategory::withoutTrashed()
            ->where('status',1)
            ->get();

        $propertyLocations = PropertyLocation::withoutTrashed()
            ->where('status',1)
            ->get();

        $settings = Setting::first();
        $title ="Our Services";
        $meta_description = $settings->meta_description;
        $image = $settings->image;
        $keywords = $settings->keywords;

        return view('livewire.frontend.services',
        [
            'services'=>$services,
            'propertyTypes'=>$propertyTypes,
            'propertyCategories'=>$propertyCategories,
            'propertyLocations'=>$propertyLocations,
            'title' => $title,
            'settings' => $settings,
        ]
    )->extends('layouts.frontend',
        [
            'propertyTypes'=>$propertyTypes,
            'propertyCategories'=>$propertyCategories,
            'propertyLocations'=>$propertyLocations,
            'settings' => $settings,
            'title' => $title,
            'meta_description' => $meta_description,
            'keywords' => $keywords,
            'image' => $image,
        ]);
    ;
    }
}
 

