<?php

namespace App\Livewire\Frontend\Property;

use App\Models\Property;
use App\Models\PropertyBooking;
use App\Models\PropertyCategory;
use App\Models\PropertyLocation;
use App\Models\PropertyType;
use App\Models\Setting;
use Illuminate\Support\Facades\Mail;
use Livewire\Attributes\Rule;
use Livewire\Component;
use Illuminate\Support\Facades\URL;

class ViewProperty extends Component
{
    public  $property;
    public $properties;
        /*    form*/
    #[Rule('required')]
    public $name='';
    #[Rule('required|email')]
    public $email='';
    #[Rule('required')]
    public $phone_number='';
    #[Rule('required')]
    public $description='';

    public function propertyBooking(){
        $url = URL::previous();
        $validated = $this->validate();
        PropertyBooking::create([

            'email' => $this->email,
            'description' => $this->description,
            'name' => $this->name,
            'phone_number' => $this->phone_number,
            'property_id' => $this->property->id

        ]);
        //send email
        $settings = Setting::first();
        Mail::to($this->email)->send(new \App\Mail\PropertyBooking($validated));
        Mail::to($settings->email)->send(new \App\Mail\AdminPropertyBooking($validated));

        $url = URL::previous();
        $this->reset();
        flash()->addSuccess('Successful', 'You have booked property Successfully');
        //session()->flash('register-message', 'You have booked property Successfully');
        $this->redirect($url);
    }

    public function mount(Property $property){

        $this->property = Property::query()
            ->where('slug', $property->slug)
            ->first();
        $this->properties = Property::query()
            ->where('id','!=',$property->id)
            ->take(3)
            ->get();

    }
    public function render()
    {

        $propertyTypes = PropertyType::withoutTrashed()
            ->where('status',1)
            ->get();
        $propertyCategories = PropertyCategory::withoutTrashed()
            ->where('status',1)
            ->get();

        $propertyLocations = PropertyLocation::withoutTrashed()
            ->where('status',1)
            ->get();
        $settings = Setting::first();
        $title =$this->property->name;
        $meta_description = $this->property->meta_description;
        $image = $this->property->image;
        $keywords = $this->property->keywords;
        return view('livewire.frontend.property.view-property',
            [
                'property'=>$this->property,
                'properties'=>$this->properties,
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'title' => $title,
                'settings' => $settings,
            ])->extends('layouts.frontend',
            [
                'property'=>$this->property,
                'properties'=>$this->properties,
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'settings' => $settings,
                'title' => $title,
                'meta_description' => $meta_description,
                'keywords' => $keywords,
                'image' => $image,
            ]);
    }
}
