<?php

namespace App\Livewire\Frontend\Property;

use App\Models\Property;
use App\Models\PropertyType as Type;
use App\Models\PropertyCategory;
use App\Models\PropertyLocation;
use App\Models\Setting;
use Livewire\Component;
use Livewire\WithPagination;

class PropertyType extends Component
{
    use WithPagination;
    public  $propertyType;
    //public  $properties;



    public function render()
    {

        $type = Type::withoutTrashed()
            ->where('slug',$this->propertyType)
            ->first();

        //check relationship
        $properties= $type->property()->where('status',1)->paginate();



        $propertyTypes = Type::withoutTrashed()
            ->where('status',1)
            ->get();
        $propertyCategories = PropertyCategory::withoutTrashed()
            ->where('status',1)
            ->get();

        $propertyLocations = PropertyLocation::withoutTrashed()
            ->where('status',1)
            ->get();
        $settings = Setting::first();
        $title =$type->name;
        $meta_description = $type->meta_description;
        $image = $type->image;
        $keywords = $type->keywords;
        return view('livewire.frontend.property.property-type',
            [
                'properties'=>$properties,
                'propertyType'=>$this->propertyType,
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'title' => $title,
            ])->extends('layouts.frontend',
            [
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'settings' => $settings,
                'title' => $title,
                'meta_description' => $meta_description,
                'keywords' => $keywords,
                'image' => $image,
            ]);
    }
}
