<?php

namespace App\Livewire\Frontend\Property;

use App\Models\Property;
use App\Models\PropertyCategory;
use App\Models\PropertyLocation;
use App\Models\PropertyType;
use App\Models\Setting;
use Livewire\Component;
use Livewire\WithPagination;

class PropertySearch extends Component
{
    use WithPagination;
    public $propertyType = "";
    public $propertyCategory = "";
    public $propertyLocation = "";



    /*public function SearchResults(){
        $this->properties = Property::query()
            ->where('status',1)
            ->orWhere('property_type_id',$this->propertyType)
            ->orWhere('property_category_id',$this->propertyCategory)
            ->paginate();

        dd($this->properties);
    }*/

    public function render()
    {

        $properties = Property::query()
            ->where('status',1)
            ->orWhere('property_type_id',$this->propertyType)
            ->orWhere('property_category_id',$this->propertyCategory)
            ->paginate();

        $propertyTypes = PropertyType::withoutTrashed()
            ->where('status',1)
            ->get();
        $propertyCategories = PropertyCategory::withoutTrashed()
            ->where('status',1)
            ->get();

        $propertyLocations = PropertyLocation::withoutTrashed()
            ->where('status',1)
            ->get();
        $settings = Setting::first();
        $title =$settings->title;
        $meta_description = $settings->meta_description;
        $image = $settings->image;
        $keywords = $settings->keywords;
        return view('livewire.frontend.property.property-search',
            [
                'properties'=>$properties,
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'title' => $title,
            ])->extends('layouts.frontend',
            [
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'settings' => $settings,
                'title' => $title,
                'meta_description' => $meta_description,
                'keywords' => $keywords,
                'image' => $image,
            ]);
    }
}
