<?php

namespace App\Livewire\Frontend\Property;

use App\Models\Property;
use App\Models\PropertyCategory;
use App\Models\PropertyType;
use App\Models\Setting;
use Livewire\Component;
use Livewire\WithPagination;

class PropertyLocation extends Component
{
    use WithPagination;
public  $propertyLocation;
public  $relatedLocation;
    public function mount(\App\Models\PropertyLocation $propertyLocation){


        $this->relatedLocation = \App\Models\PropertyLocation::query()
            ->where('id','!=',$propertyLocation->id)
            ->take(3)
            ->get();

    }


    public function render()
    {
        $properties= Property::query()
            ->where('property_location_id', $this->propertyLocation->id)
            ->paginate();

        $propertyTypes = PropertyType::withoutTrashed()
            ->where('status',1)
            ->get();
        $propertyCategories = PropertyCategory::withoutTrashed()
            ->where('status',1)
            ->get();

        $propertyLocations = \App\Models\PropertyLocation::withoutTrashed()
            ->where('status',1)
            ->get();
        $settings = Setting::first();
        $title =$this->propertyLocation->name;
        $meta_description = $settings->meta_description;
        $image = $settings->image;
        $keywords = $settings->keywords;
        return view('livewire.frontend.property.property-location',
            [
                'properties'=>$properties,
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'title' => $title,
            ])->extends('layouts.frontend',
            [
                'properties'=>$properties,
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'settings' => $settings,
                'title' => $title,
                'meta_description' => $meta_description,
                'keywords' => $keywords,
                'image' => $image,
            ]);
    }
}
