<?php

namespace App\Livewire\Frontend\Property;

use App\Models\PropertyLocation;
use App\Models\PropertyType;
use App\Models\PropertyCategory as Category;
use App\Models\Setting;
use Livewire\Component;
use Livewire\WithPagination;

class PropertyCategory extends Component
{
    use WithPagination;
    public $propertyCategory;
    public $propertyType;
    public function render()
    {
        $type = PropertyType::withoutTrashed()
            ->where('slug',$this->propertyType)
            ->first();
        $category = Category::withoutTrashed()
            ->where('slug',$this->propertyCategory)
            ->first();

        //check relationship
        $properties= $category
            ->property()
            ->where('status',1)
            ->where('property_type_id',$type->id)
            ->paginate(12);

        $propertyTypes = PropertyType::withoutTrashed()
            ->where('status',1)
            ->get();
        $propertyCategories = \App\Models\PropertyCategory::withoutTrashed()
            ->where('status',1)
            ->get();

        $propertyLocations = PropertyLocation::withoutTrashed()
            ->where('status',1)
            ->get();
        $settings = Setting::first();
        $title =$category->name;
        $meta_description = $category->meta_description;
        $image = $category->image;
        $keywords = $category->keywords;
        return view('livewire.frontend.property.property-category',
            [
                'properties'=>$properties,
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'title' => $title,
            ])->extends('layouts.frontend',
            [
                'properties'=>$properties,
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'settings' => $settings,
                'title' => $title,
                'meta_description' => $meta_description,
                'keywords' => $keywords,
                'image' => $image,
            ]);
    }
}
