<?php

namespace App\Livewire\Frontend\Property;

use App\Models\Property;
use App\Models\PropertyCategory;
use App\Models\PropertyLocation;
use App\Models\PropertyType;
use App\Models\Setting;
use Livewire\Component;
use Livewire\WithPagination;

class AllProperties extends Component
{
    use WithPagination;

    public function render()
    {

        $properties = Property::withoutTrashed()
            ->where('status',1)
            ->paginate(12);



        $propertyTypes = PropertyType::withoutTrashed()
            ->where('status',1)
            ->get();
        $propertyCategories = PropertyCategory::withoutTrashed()
            ->where('status',1)
            ->get();

        $propertyLocations = PropertyLocation::withoutTrashed()
            ->where('status',1)
            ->get();

        $settings = Setting::first();
        $title =$settings->title;
        $meta_description = $settings->meta_description;
        $image = $settings->image;
        $keywords = $settings->keywords;
        return view('livewire.frontend.property.all-properties',
        [
            'properties' => $properties,
            'propertyTypes'=>$propertyTypes,
            'propertyCategories'=>$propertyCategories,
            'propertyLocations'=>$propertyLocations,
            'title' => $title,
        ]



        )->extends('layouts.frontend',
            [
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'settings' => $settings,
                'title' => $title,
                'meta_description' => $meta_description,
                'keywords' => $keywords,
                'image' => $image,
            ]);
    }
}
