<?php

namespace App\Livewire\Frontend\Pages;

use App\Models\Enquiry;
use App\Models\PropertyCategory;
use App\Models\PropertyLocation;
use App\Models\PropertyType;
use App\Models\Setting;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\URL;
use Livewire\Attributes\Rule;
use Livewire\Component;

class Contact extends Component
{

    #[Rule('required')]
    public $name='';
    #[Rule('required|email')]
    public $email='';
    #[Rule('required')]
    public $phone_number='';
    #[Rule('required')]
    public $subject='';
    #[Rule('required')]
    public $message='';
    public function enquiry()
    {
        $url = URL::previous();
        $validated = $this->validate();
        Enquiry::create([

            'email' => $this->email,
            'message' => $this->message,
            'name' => $this->name,
            'phone_number' => $this->phone_number,
            'subject' => $this->subject

        ]);
        //send email
        $settings = Setting::first();
        Mail::to($this->email)->send(new \App\Mail\Enquiry($validated));
        Mail::to($settings->email)->send(new \App\Mail\AdminEnquiry($validated));

        $url = URL::previous();
        $this->reset();
        flash()->addSuccess('Successful', 'You have booked property Successfully');
        //session()->flash('register-message', 'You have booked property Successfully');
        $this->redirect($url);



    }
    public function render()
    {

        $propertyTypes = PropertyType::withoutTrashed()
            ->where('status',1)
            ->get();
        $propertyCategories = PropertyCategory::withoutTrashed()
            ->where('status',1)
            ->get();

        $propertyLocations = PropertyLocation::withoutTrashed()
            ->where('status',1)
            ->get();
        $settings = Setting::first();
        $title ="Contact Us";
        $meta_description = $settings->meta_description;
        $image = $settings->image;
        $keywords = $settings->keywords;
        return view('livewire.frontend.pages.contact',
        [
            'propertyTypes'=>$propertyTypes,
            'propertyCategories'=>$propertyCategories,
            'propertyLocations'=>$propertyLocations,
            'title' => $title,
            'settings' => $settings,
        ]

        )->extends('layouts.frontend',
            [
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'settings' => $settings,
                'title' => $title,
                'meta_description' => $meta_description,
                'keywords' => $keywords,
                'image' => $image,
            ]);
    }
}
