<?php

namespace App\Livewire\Frontend\Pages;

use App\Models\CoreValue;
use App\Models\PropertyCategory;
use App\Models\PropertyLocation;
use App\Models\PropertyType;
use App\Models\Setting;
use Livewire\Component;

class About extends Component
{
    public function render()
    {
        $about = \App\Models\About::first();

        $coreValues = CoreValue::query()
            ->where('status',1)
            ->orderByraw('CHAR_LENGTH(description) DESC')
            ->get();

        $propertyTypes = PropertyType::withoutTrashed()
            ->where('status',1)
            ->get();
        $propertyCategories = PropertyCategory::withoutTrashed()
            ->where('status',1)
            ->get();

        $propertyLocations = PropertyLocation::withoutTrashed()
            ->where('status',1)
            ->get();

        $settings = Setting::first();
        $title =$about->title;
        $meta_description = $settings->meta_description;
        $image = $settings->image;
        $keywords = $settings->keywords;
        return view('livewire.frontend.pages.about',
            [
                'about'=>$about,
                'coreValues'=>$coreValues,
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'title' => $title,
                'settings' => $settings,
            ]
        )->extends('layouts.frontend',
            [
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'settings' => $settings,
                'title' => $title,
                'meta_description' => $meta_description,
                'keywords' => $keywords,
                'image' => $image,
            ]);
    }
}
