<?php

namespace App\Livewire\Frontend;

use App\Models\Property;
use App\Models\PropertyCategory;
use App\Models\PropertyLocation;
use App\Models\PropertyType;
use App\Models\Setting;
use App\Models\Slide;
use Livewire\Component;

class IndexHome extends Component
{
    public $propertyType = "";
    public $propertyCategory = "";
    public $propertyLocation = "";

    public function SearchResults(){
        $properties = Property::query()
            ->where('status',1)
            ->orWhere('property_type_id',$this->propertyType)
            ->orWhere('property_category_id',$this->propertyCategory)
            ->orWhere('property_location_id',$this->propertyLocation)
            ->paginate();

        //redirect to a page here
       return redirect()->away(route('frontend.property-search'));



    }

    public function render()
    {
        $slides = Slide::query()
            ->where('status',1)
            ->first();
        $properties = Property::withoutTrashed()
            ->where('status',1)
            ->orderByDesc('created_at')
            ->take(6)
            ->get();

        $propertyTypes = PropertyType::withoutTrashed()
        ->where('status',1)
        ->get();
        $propertyCategories = PropertyCategory::withoutTrashed()
            ->where('status',1)
            ->get();

        $propertyLocations = PropertyLocation::withoutTrashed()
            ->where('status',1)
            ->get();


        $settings = Setting::first();
        $title =$settings->title;
        $meta_description = $settings->meta_description;
        $image = $settings->image;
        $keywords = $settings->keywords;
        return view('livewire.frontend.index-home',
        [
            'slides'=>$slides,
            'properties'=>$properties,
            'propertyTypes'=>$propertyTypes,
            'propertyCategories'=>$propertyCategories,
            'propertyLocations'=>$propertyLocations,
        ]



        )->extends('layouts.frontend',
            [
                'properties'=>$properties,
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'settings' => $settings,
                'title' => $title,
                'meta_description' => $meta_description,
                'keywords' => $keywords,
                'image' => $image,
            ]);
    }
}
