<?php

namespace App\Livewire\Frontend\Blogs;

use App\Models\Blog;
use App\Models\PropertyCategory;
use App\Models\PropertyLocation;
use App\Models\PropertyType;
use App\Models\Setting;
use Livewire\Component;

class ViewBlog extends Component
{
    public  $blog;
    public  $blogs;
    public function mount(Blog $blog){

        $this->blog = Blog::query()
            ->where('slug', $blog->slug)
            ->first();
        $this->blogs = Blog::query()
            ->where('id','!=',$blog->id)
            ->take(3)
            ->get();

    }

    public function render()
    {

        $propertyTypes = PropertyType::withoutTrashed()
            ->where('status',1)
            ->get();
        $propertyCategories = PropertyCategory::withoutTrashed()
            ->where('status',1)
            ->get();

        $propertyLocations = PropertyLocation::withoutTrashed()
            ->where('status',1)
            ->get();

        $settings = Setting::first();
        $title =$this->blog->name;
        $meta_description = $this->blog->meta_description;
        $image = $this->blog->image;
        $keywords = $this->blog->keywords;
        return view('livewire.frontend.blogs.view-blog',
            [

                'blog'=>$this->blog,
                'blogs'=>$this->blogs,
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'title' => $title,
            ]



        )->extends('layouts.frontend',
            [
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'settings' => $settings,
                'title' => $title,
                'meta_description' => $meta_description,
                'keywords' => $keywords,
                'image' => $image,
            ]);
    }
}
