<?php

namespace App\Livewire\Frontend\Blogs;

use App\Models\Blog;
use App\Models\PropertyCategory;
use App\Models\PropertyLocation;
use App\Models\PropertyType;
use App\Models\Setting;
use Livewire\Component;
use Livewire\WithPagination;

class BlogCategory extends Component
{
    use WithPagination;
    public $blogCategory;
    public function render()
    {

        $category = \App\Models\BlogCategory::withoutTrashed()
            ->where('slug',$this->blogCategory)
            ->first();

        $blogs = Blog::withoutTrashed()
            ->where('status',1)
            ->where('blog_category_id',$category->id)
            ->paginate(12);

        $propertyTypes = PropertyType::withoutTrashed()
            ->where('status',1)
            ->get();
        $propertyCategories = PropertyCategory::withoutTrashed()
            ->where('status',1)
            ->get();

        $propertyLocations = PropertyLocation::withoutTrashed()
            ->where('status',1)
            ->get();

        $settings = Setting::first();
        $title =$category->name;
        $meta_description = $category->meta_description;
        $image = $category->image;
        $keywords = $category->keywords;
        return view('livewire.frontend.blogs.blog-category',
            [

                'blogs'=>$blogs,
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'title' => $title,
            ]



        )->extends('layouts.frontend',
            [
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'settings' => $settings,
                'title' => $title,
                'meta_description' => $meta_description,
                'keywords' => $keywords,
                'image' => $image,
            ]);
    }
}
