<?php

namespace App\Livewire\Frontend\Blogs;

use App\Models\Blog;
use App\Models\PropertyCategory;
use App\Models\PropertyLocation;
use App\Models\PropertyType;
use App\Models\Setting;
use Livewire\Component;
use Livewire\WithPagination;

class BlogArticles extends Component
{
    use WithPagination;
    public function render()
    {
        $blogs = Blog::withoutTrashed()
            ->where('status',1)
            ->paginate(12);

        $propertyTypes = PropertyType::withoutTrashed()
            ->where('status',1)
            ->get();
        $propertyCategories = PropertyCategory::withoutTrashed()
            ->where('status',1)
            ->get();

        $propertyLocations = PropertyLocation::withoutTrashed()
            ->where('status',1)
            ->get();

        $settings = Setting::first();
        $title ="News Updates";
        $meta_description = $settings->meta_description;
        $image = $settings->image;
        $keywords = $settings->keywords;
        return view('livewire.frontend.blogs.blog-articles',
            [

                'blogs'=>$blogs,
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'title' => $title,
            ]



        )->extends('layouts.frontend',
            [
                'propertyTypes'=>$propertyTypes,
                'propertyCategories'=>$propertyCategories,
                'propertyLocations'=>$propertyLocations,
                'settings' => $settings,
                'title' => $title,
                'meta_description' => $meta_description,
                'keywords' => $keywords,
                'image' => $image,
            ]);
    }
}
