<?php

namespace App\Filament\Resources;

use App\Filament\Resources\SettingResource\Pages;
use App\Filament\Resources\SettingResource\RelationManagers;
use App\Models\Setting;
use Filament\Forms;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class SettingResource extends Resource
{
    protected static ?string $model = Setting::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
    protected static ?string $navigationLabel = 'Website Setting';
    protected static ?string $modelLabel = 'Website Setting';


    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make('Main Details & Contacts')
                    ->schema([
                        TextInput::make('name')->required()->label('Website Name')->columnSpanFull(),
                        TextInput::make('phone_number')->tel()->label('Phone Number'),
                        TextInput::make('phone_number_backup')->tel()->label('Phone Number Backup'),
                        TextInput::make('email')->email()->label('Email Address'),
                        TextInput::make('email_backup')->email()->label('Email Address Backup'),
                        TextInput::make('whatsapp')->tel()->label('WhatsApp Number'),
                        TextInput::make('whatsapp_backup')->tel()->label('WhatsApp Number Backup'),
                        RichEditor::make('address')->label(" Address"),
                        RichEditor::make('address_backup')->label("Branch Address"),

                    ])->columns(2),
                Section::make('Social Media Links')
                    ->schema([
                        TextInput::make('facebook')->url()->label('Facebook URL'),
                        TextInput::make('twitter')->url()->label('Twitter URL'),
                        TextInput::make('tiktok')->url()->label('TikTok URL'),
                        TextInput::make('instagram')->url()->label('Instagram URL'),
                        TextInput::make('linkedin')->url()->label('LinkedIn URL'),
                        TextInput::make('youtube')->url()->label('YouTube URL'),
                        TextInput::make('pinterest')->url()->label('Pinterest URL'),
                        TextInput::make('google_my_business')->url()->label("Google My Business URL"),
                        TextInput::make('direction_on_map')->url()->label("Google Map Direction URL"),

                    ])->columns(3),
                Section::make('Tracking and CSS & JavaScript Scripts')
                    ->schema([
                        Textarea::make('header_scripts')->nullable()->label('Header Scripts (Google Analytics)'),
                        Textarea::make('body_scripts')->nullable()->label('Body Scripts (Facebook Conversion Script)'),
                        Textarea::make('footer_scripts')->nullable()->label('Footer Scripts (Tawk live chat)'),
                    ])->columns(3),
                Section::make('Logo and Facon')
                    ->schema([
                        FileUpload::make('logo')->disk('public')->label("Main Logo"),
                        FileUpload::make('light_logo')->disk('public')->label("Light Logo"),
                        FileUpload::make('favicon')->disk('public')->label("Favicon"),
                    ])->columns(3),
                Section::make('Cover Image')
                    ->schema([
                        FileUpload::make('image')->disk('public')->label("Social Media Image Cover"),

                    ]),
                Section::make('SEO Settings')
                    ->schema([
                        TextInput::make('title')->label('Website SEO Title'),
                        Textarea::make('meta_description')->nullable()->label('SEO Meta Description'),
                        Textarea::make('keywords')->nullable()->label('SEO Keywords'),


                    ])
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')->label("Website Name"),
                TextColumn::make('phone_number')->label("Website Phone Number"),
                TextColumn::make('email')->label("Website  Email"),
                ImageColumn::make('logo')->label("Logo"),
                ImageColumn::make('image')->label("Social Cover Image"),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
               /* Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),*/
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSettings::route('/'),
            'create' => Pages\CreateSetting::route('/create'),
            'edit' => Pages\EditSetting::route('/{record}/edit'),
        ];
    }
}
