<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PropertyBookingResource\Pages;
use App\Filament\Resources\PropertyBookingResource\RelationManagers;
use App\Models\PropertyBooking;
use Filament\Forms;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\ToggleColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class PropertyBookingResource extends Resource
{
    protected static ?string $model = PropertyBooking::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
      protected static ?string $navigationGroup = 'Property Management';

    protected static ?int $navigationSort = 6;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make("Lead Details")
                    ->schema([

                        TextInput::make('name')->label('Customers Name'),
                        TextInput::make('email')->label('Customers Email'),
                        TextInput::make('phone_number')->label('Customers Phone Number'),
                        RichEditor::make('description')->label('Customers Request')->columnSpanFull(),

                        RichEditor::make('comments')
                            ->required()
                            ->label("Attendants Comments")
                            ->columnSpanFull(),
                    ])->columns(3),
                Section::make("Property Details & Status")
                    ->schema([
                        Select::make('property_id')->label('Property Name')
                            ->relationship('property','name')
                            ->searchable()
                            ->preload()
                            ->native(false)->required(),

                        Select::make('status')->label('Lead Status')
                            ->options([
                                '1' => 'Viewed',
                                '0' => 'Pending Enquiry'
                            ])->native(false)->required(),
                    ])->columns(2),
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')->label(" Name"),
                TextColumn::make('property.name')->label(" Property Name "),
                TextColumn::make('phone_number')->label(" Phone Number "),
                TextColumn::make('email')->label(" Email "),
                ToggleColumn::make('status')->label("Status"),
                TextColumn::make('created_at')->label("Date Submitted") ->dateTime(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPropertyBookings::route('/'),
            'create' => Pages\CreatePropertyBooking::route('/create'),
            'edit' => Pages\EditPropertyBooking::route('/{record}/edit'),
        ];
    }
}
