<?php

namespace App\Filament\Resources;

use App\Filament\Resources\EnquiryResource\Pages;
use App\Filament\Resources\EnquiryResource\RelationManagers;
use App\Models\Enquiry;
use Filament\Forms;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\ToggleColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class EnquiryResource extends Resource
{
    protected static ?string $model = Enquiry::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
     protected static ?string $navigationGroup = 'Enquiries';

    protected static ?int $navigationSort = 2;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make("Lead Details")
                    ->schema([

                        //TextInput::make('user.id')->label('Attendants Name'),
                        TextInput::make('name')->label('Customers Name'),
                        TextInput::make('email')->label('Customers Email'),
                        TextInput::make('phone_number')->label('Customers Phone Number'),
                        TextInput::make('subject')->label('Customers Subject')->columnSpanFull(),
                        RichEditor::make('message')->label('Customers Request')->columnSpanFull(),

                        RichEditor::make('comments')
                            ->required()
                            ->label("Attendants Comments")
                            ->columnSpanFull(),
                    ])->columns(3),
                Section::make(" Status")
                    ->schema([


                        Select::make('status')->label('Lead Status')
                            ->options([
                                '1' => 'Viewed',
                                '0' => 'Pending Enquiry'
                            ])->native(false)->required(),
                    ])->columns(2),
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')->label(" Name"),
                TextColumn::make('phone_number')->label(" Phone Number "),
                TextColumn::make('email')->label(" Email "),
                ToggleColumn::make('status')->label("Status"),
                TextColumn::make('created_at')->label("Date Submitted") ->dateTime(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListEnquiries::route('/'),
            'create' => Pages\CreateEnquiry::route('/create'),
            'edit' => Pages\EditEnquiry::route('/{record}/edit'),
        ];
    }
}
